import { useState } from 'react'
import { BrowserRouter as Router, Routes, Route } from 'react-router-dom';
import Navbar from "./components/Navbar.js";
import LoginPage from "./pages/LoginPage.js";
import WelcomeUser from "./components/WelcomeUser.js";
import HomePage from "./pages/HomePage.js";
import Editor from "./pages/Editor.js";
import RegisterPage from "./pages/RegisterPage.js";
import AboutUs from "./pages/AboutUs.js";
import Footer from "./components/Footer.js";
import Profile from "./pages/Profile.js";
import Articles from "./pages/Articles.js";
import ArticleDetail from "./pages/ArticleDetail.js";
import AdminTable from "./pages/AdminTable.js";
import React from 'react';
import { TopicsProvider } from './contexts/TopicsContext.js';
import { UserProvider } from './contexts/UserContext.js';
import ArticlePreview from './pages/ArticlePreview.js';

function App() {

    return (
        <Router>
            <TopicsProvider>
                <UserProvider>
                    <div className="flex flex-col min-h-screen">
                        <Navbar />
                        <main className="flex-grow">
                            <Routes>
                                <Route path="/" element={<HomePage />} />
                                <Route path="/login" element={<LoginPage />} />
                                <Route path="/register" element={<RegisterPage />} />
                                <Route path="/editor" element={<Editor />} />
                                <Route path="/about" element={<AboutUs />} />
                                <Route path="/profile" element={<Profile />} />
                                <Route path="/articles" element={<Articles />} />
                                <Route path="/article/:id" element={<ArticleDetail />} />
                                <Route path="/article_preview/:id" element={<ArticlePreview />} />
                                <Route path="/admin" element={<AdminTable />} />
                            </Routes>
                        </main>
                        <Footer />
                    </div>
                </UserProvider>
            </TopicsProvider>


        </Router>
    );
}

export default App
