import Rating from '@mui/material/Rating';
import VisibilityIcon from '@mui/icons-material/Visibility';
import HourglassTopIcon from '@mui/icons-material/HourglassTop';
import React from 'react';
import { Article } from '../types/article';
import { Link } from 'react-router-dom';
import { capitalizeCzech, getTopicColor } from '../utils/cz_uk';

interface ArticleCardProps {
  article: Article;
}

const ArticleCard = (props: ArticleCardProps) => {
  const article: Article = props.article;

  return (
    <Link to={`/article/${article.id}`} className="no-underline text-inherit">
      <div className="bg-white rounded-xl shadow-md hover:shadow-lg transform hover:scale-105 transition duration-300 ease-in-out p-5 flex flex-col justify-between w-full sm:max-w-md md:max-w-lg lg:max-w-xl mx-auto min-w-70 min-h-50">
      {/* TOP */}
      <div className="flex justify-between text-sm text-gray-600 mb-2">
        <div>
          <span>Autor: </span>
          <span className='font-semibold'>{article.author}</span>
        </div>
        <div className="flex items-center gap-1">
          <HourglassTopIcon fontSize="small" />
          {article.time_estimate}
        </div>
      </div>

      {/* TITLE STRIP */}
      <div
        className="text-center text-white font-bold py-3 px-4 rounded-lg mb-4"
        style={{ backgroundColor: getTopicColor(article.topic) }}
      >
        {article.title}
      </div>

      {/* BOTTOM */}
      <div className="flex justify-between items-end text-sm text-gray-700">
        <div>
          <div className="text-xs text-gray-500 text-left">Téma:</div>
          <div className="font-semibold truncate">
            {((text: string) =>
              text.length > 30 ? text.slice(0, 30) + '...' : text
            )(capitalizeCzech(article.topic) ?? 'Není specifikované')}
          </div>
        </div>
        <div className="text-right">
          <div className="flex items-center justify-end gap-1">
            <VisibilityIcon fontSize="small" />
            {article.usage_count}
          </div>
          <Rating value={article.rating} precision={0.5} readOnly size="small" />
        </div>
      </div>
    </div>
    </Link>
  );
};

export default ArticleCard;
