import React from 'react';
import Editor from './Editor.js';
import CommentSection from '../components/CommentSection.js';
import ArticleCard from "../components/ArticleCard.js";
import Displayer from '../components/Displayer.js';
import ArticleDetail from './ArticleDetail.js';

const AboutUs = () => {
    const teamMembers = [
        {
            name: "Kristýna Mičková",
            role: "Vedoucí projektu",
            image: "/team/placeholder/150/150"
        },
        {
            name: "RNDr. Světlana Tomiczková, Ph.D.",
            role: "Pedagogický konzultant",
            image: "/team/placeholder/150/150"
        },
        {
            name: "Vitalij Atamanjuk",
            role: "Vývojář aplikace",
            image: "/team/atmnk.jpg"
        },
        {
            name: "Vojtěch Aloy",
            role: "Vývojář aplikace",
            image: "/team/vojta.jpg"
        },
        {
            name: "Marek Ondriáš",
            role: "Vývojář aplikace",
            image: "/team/marekond.jpg"
        },
        {
            name: "Martin Opelka",
            role: "Vývojář aplikace",
            image: "/team/martin.jpg"
        }
    ];

    return (
        <div>
            <div className="max-w-6xl mx-auto px-4 py-8">
                <h2 className="text-xl text-green-950 font-bold text-center mb-8">Vítejte na webovém portálu Matematika moderně.</h2>
                <p className="text-base text-gray-700 px-4 py-2 leading-relaxed">
                    Projekt Matematika moderně si klade za cíl vytvořit fungující webový portál pro distribuci didaktických pomůcek pro vyučující matematiky na gymnáziích. Ke každé pomůcce je připojen článek, který shrnuje jak danou pomůcku může vyučující využívat.<br /><br />
                    Na horizontální liště se nachází kategorie ,,Témata.“ Tato témata získala svůj název na základě Rámcového vzdělávacího programu pro gymnázia (v úplném znění) s účinností od 1. září 2022. Z tohoto důvodu je tento webový portál primárně určen pro učitelé gymnázií.<br /><br />
                    Projekt Matematika moderně je zaměřen na podporu modernizace výuky matematiky na gymnáziích. Nabízí didaktické pomůcky přehledně na jednom místě. Záměrem je také napomáhat k rozvoji digitálních kompetencí jak u vyučujících, tak u žáků. V důsledku toho webový portál nabízí nejen pomůcky v PDF formě pro tisk, ale také digitální pomůcky. Pomůcky jsou také označeny časovou náročností a obtížností.<br /><br />
                    Cílem je vytvořit prostředí pro vyučující matematiky, ze kterého mohou čerpat, ale také sami přispívat, a proto zde naleznete i možnost články s didaktickými pomůckami komentovat, dokonce i přispívat svými příspěvky. Články spolu s didaktickými pomůckami může přidat jen přihlášený uživatel a jeho práce následně projde schválením než bude volně přístupný.<br /><br />
                    Tento projekt vznikl v rámci předmětu ZSWI/ZSW-E projects for summer semester 2025, který vytvořila Fakulta aplikovaných věd Západočeské univerzity na základě žádosti zakladatelky.
                </p>
                <div className="mt-12 mb-8">
                    <h2 className="text-xl text-green-950 font-bold text-center mb-8">Na projektu se podílí:</h2>

                    <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
                        {teamMembers.map((member, index) => (
                            <div key={index} className="flex items-center bg-amber-100 p-4 rounded-lg shadow-md">
                                <div className="flex-shrink-0">
                                    <img
                                        src={member.image}
                                        //alt={`${member.name} profile`}
                                        className="w-24 h-24 rounded-full object-cover border-2 border-green-950"
                                    />
                                </div>
                                <div className="ml-6">
                                    <h3 className="text-xl font-semibold text-green-950">{member.name}</h3>
                                    <p className="text-md text-green-800">{member.role}</p>
                                </div>
                            </div>
                        ))}
                    </div>
                </div>
            </div>
        </div>
    );
};

export default AboutUs;
