import React, { useEffect } from 'react';
import WelcomeUser from '../components/WelcomeUser';
import Carousel from "../components/Carousel";
import { Article } from '../types/article';
import { useQueries } from '@tanstack/react-query';
import api from '../utils/api';

const HomePage: React.FC = () => {

    const results = useQueries({
        queries: [
            {
                queryKey: ['articles', 'recommended'],
                queryFn: () => api.get<Article[]>('/articles/recommended').then(res => res.data),
            },
            {
                queryKey: ['articles', 'favorite'],
                queryFn: () => api.get<Article[]>('/articles/favorite').then(res => res.data),
            },
            {
                queryKey: ['articles', 'latest'],
                queryFn: () => api.get<Article[]>('/articles/latest').then(res => res.data),
            },
        ],
    });

    const [
        { data: recommendedArticles = [], isLoading: rLoad },
        { data: popularArticles = [], isLoading: pLoad },
        { data: latestArticles = [], isLoading: lLoad },
    ] = results;

    return (

        <div style={{ padding: '2rem', textAlign: 'center' }}>
            <WelcomeUser />

            <Carousel articles={latestArticles} name="Poslední" />
            <Carousel articles={popularArticles} name="Oblíbené" />
            <Carousel articles={recommendedArticles} name="Doporučené" />
        </div>
    );
};

export default HomePage;
