import { Article } from "./article";
import { Comment } from "./comment";

export interface User {
    id: number;
    username: string;
    email: string;
    role: string;
    profilePicture: string;
    bio: string;
}

export interface UserForAdmin extends User {
    articles: Article[]; // Assuming you have an Article type defined elsewhere
    comments: Comment[]; // Assuming you have a Comment type defined elsewhere
}

export enum Role{
    USER = "user", // neregistrovaný uživatel
    TEACHER = "ucitel", // přihlášený učitel (učitelé)
    SPRAVCE = "spravce", // Správce článků
    ADMIN = "admin" // Administrátor
}