import axios from 'axios';
import { wrapper } from 'axios-cookiejar-support';
import { CookieJar } from 'tough-cookie';

const cookieJar = new CookieJar();

const api = wrapper(axios.create({
  baseURL: import.meta.env.VITE_API_URL,
  withCredentials: true,
  jar: cookieJar
}));

api.interceptors.response.use(
  res => res,
  err => {
    // handle 401, show toast, etc.
    return Promise.reject(err);
  }
);

export default api;
