// Returns a string with the first letter capitalized in Czech locale
const capitalizeCzech = (text: String) => {
  const lower = text.trim().toLocaleLowerCase('cs-CZ');
  return lower ? lower.charAt(0).toLocaleUpperCase('cs-CZ') + lower.slice(1) : '';
};

const getTopicColor = (topic) => {
  const topicColors = {
    'ARGUMENTACE A OVĚŘOVÁNÍ': '#9C27B0', // Purple: logic, verification
    'ČÍSLO A PROMĚNNÁ': '#1976D2',         // Blue: numbers, variables
    'PRÁCE S DATY, KOMBINATORIKA, PRAVDĚPODOBNOST': '#009688', // Teal: data analysis
    'ZÁVISLOSTI A FUNKČNÍ VZTAHY': '#e09616', // Green: functional relationships
    'GEOMETRIE': '#4CAF50',
  };
  return topicColors[topic] || '#9BE48F';
};

const mapToName = (status: string) => {
        switch (status) {
            case 'APPROVED': return 'Schváleno';
            case 'REJECTED': return 'Zamítnuto';
            case 'IN_PROGRESS': return 'Čeká na schválení';
            default: return 'Neznámý stav';
        }
    };


    const statusColor = (status: string) => {
        switch (status) {
            case 'APPROVED': return 'success';
            case 'REJECTED': return 'error';
            case 'IN_PROGRESS': return 'warning';
            default: return 'default';
        }
    };

// Normalize Czech diacritics so backend can match
const normalizeCzech = (str: string) =>
    str
      .normalize('NFD')
      .replace(/[\u0300-\u036f]/g, '')
      .toLowerCase();

export { capitalizeCzech };
export { getTopicColor };
export { normalizeCzech };
export { mapToName };
export { statusColor };