﻿using OpenTK.Graphics.OpenGL4;
using OpenTK.Mathematics;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace OpenTK_tutorial
{
    internal class FlatShader : ShaderProgram
    {
        public FlatShader(string vertexPath, string fragmentPath) : base(vertexPath, fragmentPath)
        {
        }

        internal virtual void SetUniforms(Matrix4 view, Matrix4 projection, Vector3 color)
        {
            float time = t.ElapsedMilliseconds;

            int location = GL.GetUniformLocation(Handle, "baseColor");
            GL.Uniform3(location, color);

            location = GL.GetUniformLocation(Handle, "time");
            GL.Uniform1(location, time);

            base.SetUniforms(view, projection);
        }
    }
}
