﻿using OpenTK.Graphics.OpenGL4;
using OpenTK.Mathematics;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection.Metadata;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using static OpenTK.Graphics.OpenGL.GL;

namespace OpenTK_tutorial
{
    class MeshObject : GameObject
    {
        MeshX mesh;

        public MeshObject(float scale, string meshPath, string texturePath)
        {
            this.scale = scale;

            mesh = new MeshX(meshPath, texturePath);
            model = Matrix4.CreateScale(scale, scale, scale);
            model *= Matrix4.CreateRotationZ(90);
        }

        public override void Initialize()
        {
            // use textures
            mesh.Init();
        }

        public override void Draw(ShaderProgram shader)
        {
            int location = GL.GetUniformLocation(shader.Handle, "texture0");
            GL.Uniform1(location, 0);
            location = GL.GetUniformLocation(shader.Handle, "texture1");
            GL.Uniform1(location, 1);

            shader.SetModel(model);
            mesh.Render();
        }

    }
}
