#version 330 core
out vec4 FragColor;

in vec3 fragPos;
in vec3 normal;
in vec3 color;
in vec2 uv;

uniform sampler2D texture0;
uniform sampler2D texture1;

uniform float isTex;
uniform vec3 viewPos;

void main()
{
    vec4 tex1 = vec4(color, 1.0);
    if (isTex == 1)
        tex1 = texture(texture0, uv);

    vec3 norm = normalize(normal);
    vec3 viewDir = normalize(viewPos - fragPos);

    float angle = dot(norm, viewDir);
    //if (angle <= 0)
    //    discard;

    FragColor = tex1;
}