﻿using OpenTK.Graphics.OpenGL4;
using OpenTK.Mathematics;

namespace OpenTK_tutorial
{
    internal class FlatTexShader : ShaderProgram
    {
        public FlatTexShader(string vertexPath, string fragmentPath) : base(vertexPath, fragmentPath)
        {
        }

        internal virtual void SetUniforms(Matrix4 view, Matrix4 projection)
        {
            // set textures
            int location = GL.GetUniformLocation(Handle, "texture0");
            GL.Uniform1(location, 0);

            base.SetUniforms(view, projection);
        }
    }
}
