﻿using OpenTK.Graphics.OpenGL4;
using OpenTK.Mathematics;

namespace OpenTK_tutorial
{
    internal class VolumeShader : ShaderProgram
    {
        public VolumeShader(string vertexPath, string fragmentPath) : base(vertexPath, fragmentPath)
        {
        }

        internal override void SetUniforms(Matrix4 view, Matrix4 projection)
        {
            base.SetUniforms(view, projection);

            float secs = (int)((t.ElapsedMilliseconds / 100) % 190);

            // set textures 0, 1, 2
            int texLoc = GL.GetUniformLocation(Handle, "texture2");
            GL.Uniform1(texLoc, 2);

            int timeLoc = GL.GetUniformLocation(Handle, "t");
            GL.Uniform1(timeLoc, secs);

        }
    }
}
