#version 330 core
out vec4 FragColor;

in vec2 uv;

uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler3D texture2;

uniform float t;

vec4 Scene(vec3 pos)
{
    vec4 color;

    float scale = 20;
    pos *= scale;
    color.xyzw = vec4(step(0.7,dot(vec3(1,1,1),sin(pos))));
    pos *= 2;
    vec3 norm = -cos(pos);
    color.xyz *= 0.3 + 0.4 * clamp(dot(vec3(0.5,0.5,0.5), normalize(norm)), 0, 1);
    return color;
}

void main()
{
    vec4 from = texture(texture0, uv);
    vec4 to = texture(texture1, uv);
    vec4 dir = (to-from);

    vec3 pos;
    vec3 color = vec3(0.0);
    float alpha = 0;

    // if (length(dir) < 0.01)
    //    discard;

    for (float t = 0.0; t < 1.0; t += 0.01)
    {
        pos = from.xyz + dir.xyz * pow(t, 2);

        vec4 c = texture(texture2, pos); // Scene(pos);
        if (c.w < 0.05) continue;

        color = color * (1-c.w) + c.xyz * c.w;
        // color += c.xyz;
        alpha += c.w;

        if (alpha > 1) break;
    }

    // if (alpha < 0.01)
    //    discard;

    FragColor = vec4(color, 1);
}