t = 0:10:100;
p = [.94 .96 1.0 1.05 1.07 1.09 1.14 1.17 1.21 1.24 1.28]';
V = vandermonde(t, 1);
linearpoly = (V'*V)\(V'*p);
absolutezero = -linearpoly(1)/linearpoly(2);
fprintf('The estimate for absolute zero = %.1f\n', absolutezero);
plot(t, p, 's', 'MarkerSize', 8, 'MarkerEdgeColor','k',...
     'MarkerFaceColor','g');
xlabel('Temperature (C)');
ylabel('Pressure (atm)');
title('Raw Data');
figure
tl = [0 100];
regline = linearpoly(2)*tl + linearpoly(1);
plot(t, p, '+k', tl, regline, 'k');
title('Data and the Regression Line');
xlabel('Temperature (C)');
ylabel('Pressure (atm)');
figure
tl = [-300 100];
regline = linearpoly(2)*tl + linearpoly(1);
plot(tl, regline, t, p, 'k.', 'MarkerSize', 18);
hold on;
plot([absolutezero], [0], '*r', 'MarkerSize', 10);
title('Extrapolation of Absolute Zero');
hold off;
