function max = approxinfnorm(A)
% approxinfnorm Approximate the infinity norm of matrix A.
%
%   approxinf = approxinfnorm(A) generates 10,000 random values
%   on the unit circle in the plane and eturns the maximum value
%   of norm(Ax,'inf').

max = 0.0;
for i = 1:10000
	r = 1 - 2*rand;
	if i <= 2500
		x = [1.0 r]';
	elseif i <= 5000
		x = [r, 1.0]';
	elseif i <= 7500
		x = [-1.0 r]';
	else
		x = [r -1.0]';
	end

	bvalue = norm(A*x,'inf');
	if bvalue > max
		max = bvalue;
	end
end
   