function fval = biharmonic_f(x,y)
%BIHARMONIC_F Right-hand side for the sample biharmonic equation in text
%   The right-hand side function for u_xxxx + 2u_xxyy + u_yyyy = f,
%   u(x,y) = 1 on the boundary of unit square 0 <= x,y <= 1, normal
%   derivative zero on each side of the square

fval = 56400*(1-10*x+15*x^2)*(1-y)^2*y^4+...
       18800*x*x*(6-20*x+15*x*x)*y*y*(6-20*y+15*y*y)+...
       56400*(1-x)^2*x^4*(1-10*y+15*y*y);

end

