function [min, max] = checkeigb(A,V,D)
%CHECKEIGB V are eigenvectors corrresponding
%to eigenvalues on the diagonal of D. The
%function returns the minimum and maximum
%values of norm(A*v - lambda*v).

n = size(V,1);

min = inf;
max = -inf;

for i = 1:n
   normval = norm(A*V(:,i) - D(i,i)*V(:,i));

   if normval > max
      max = normval;
   end
   if normval < min
      min = normval;
   end
end
