function E = clgrsch(V)
% grschmidt Classical Gram-Schmidt method.
%
%   E = clgrsch(V) converts a set of linearly independent column
%   vectors in the n x k matrix V to a set of orthonormal vectors
%   in matrix E spanning the same subspace.

[n, k] = size(V);
% allocate the output matrix E
E = zeros(n, k);

% begin the computation
for i=1:k
	% sum the projections of E(:,j) onto V(:,i), 1 <= j <= i-1
	% with the sum assigned to sum_proj
	sum_proj = zeros(n,1);
	for j=1:i-1
		sum_proj = sum_proj + E(:,j)'*V(:,i)*E(:,j);
	end
	% remove the projections from V(:,i)
	E(:,i) = V(:,i) - sum_proj;
	% normalize E(:,i)
	E(:,i) = E(:,i)/norm(E(:,i));
end