function E = eigqr_demo(A)
%EIGQR QR iteration for computing all
%the eigenvalues of a real n x n matrix having
%distinct eigenvalues.
%E = eigqr(A, numiter) executes the QR iteration
%for matrix A numiter times and returns a column
%vector D containing the approximate eigenvalues
%in no particular order.
%Input: n x n matrix A and integer numiter
%Output: n x 1 matrix E

n = max(size(A));
iter = 0;
disp('Original matrix');
spy(A);
pause;
H = hhess_demo(A);
disp('Completed transformation to upper Hessenberg form.');
disp('Begin shifted QR algorithm.');
H(abs(H)<1.e-7)=0;
spy(H);
pause;

tol = 1.0e-8;
itmax = 100;
for k=n:-1:2
	I = eye(k);
	while abs(H(k,k-1)) > tol*(abs(H(k,k)) + abs(H(k-1,k-1)))
		iter = iter + 1;
		if iter > itmax
			E = diag(H);
			disp('Iteration failed');
			return;
		end
		sigma = H(k,k);
		[Q, R] = givensqr(H(1:k,1:k) - sigma*I);
		H(1:k,1:k) = R*Q + sigma*I;
   end
	H(k,k-1) = 0;
   H(abs(H)<1.e-7)=0;
	spy(H);
   pause;
end

H(abs(H)<1.e-7)=0;
spy(H);
pause;
E = diag(H);
