function H = hhess_demo(A) 
%HOUSHESS Householder Hessenberg reduction 
%H = hhess(A) produces an upper Hessenberg matrix H from A
%using Householder reflections such that H is orthogonally
%similar to A. The matrix H is built as J_(n-2)...J_1AJ_1'...J_(n-2)'
%input  : Matrix A
%output : Matrix H

n = size(A,1);
H = A;
viewalg(H);

for k=1:n-2
	[u, beta] = house(H,k+1,k);
	H(k+1:n,k:n) = H(k+1:n,k:n) - beta*(u*u')*H(k+1:n,k:n);
	H(1:n,k+1:n) = H(1:n,k+1:n) - beta*H(1:n,k+1:n)*(u*u');
	viewalg(H);
end
