function [x, r, iter] = gmres_pregmres(A,b,m,tol,reorthog)

[p n] = size(A);
if p ~= n
   error('The matrix must be square.');
end

if nargin == 3
   tol = 1.0e-6;
   reorthog = 0;
else
   reorthog = 0;
end
x0 = zeros(n,1);

disp('Density plot of A followed by its approximate condition number');
spy(A);
condest(A)
disp('Press the space bar to continue.');
pause;

niter = 100;
tic;[x, r, iter] = gmresb(A,b,x0,m,tol,niter,reorthog);toc;
disp('Residual and number of iterations executed without preconditioning.');
r
iter

tic;[x, r, iter] = mpregmres(A,b,x0,m,tol,niter,reorthog);toc;
disp('Residual and number of iterations executed with preconditioning');
r
iter
