condnum = 10:50:2000;
iters1 = zeros(length(condnum),1);
iters2 = zeros(length(condnum),1);
b = 100*rand(800,1);
x0 = ones(800,1);
for i = 1:length(condnum)
   A = sprandsym(800,.05,1/condnum(i),1);
   [x1, r1, iter1] = cg(A,b,x0,1.0e-6,500);
   [x2, r2, iter2] = precg(A,b,x0,1.0e-6,50,'incomplete Cholesky');
   iters1(i) = iter1;
   iters2(i) = iter2;
end

plot(condnum,iters1,'k',condnum,iters2,':k','LineWidth',2);
title('Number of iterations of CG and PRECG as $\kappa\left(A\right)$ increases',...
      'FontSize',12,'interpreter','latex');
legend('CG','PRECG','Location','NorthWest');
xlabel('Condition number');
ylabel('Number of iterations');
