function cgprecg(A)

[p, n] = size(A);
if p ~= n
   error('The matrix must be square');
end

m = 10:50:500;
k = length(m);
b = ones(n,1);
x0 = randn(n,1);
r1 = zeros(k,1);
r2 = zeros(k,1);

disp('Conjugate gradient method.');
tic;
for i = 1:k
[~, r1(i), ~] = cg(A,b,x0,1.0e-6,m(i));
end
toc;

disp('Preconditioned conjugate gradient method');
tic;
for i = 1:k
[~, r2(i), ~] = precg(A,b,x0,1.0e-6,m(i),'incomplete Cholesky');
end
toc;

subplot(1,2,1);
semilogy(m,r1);
title('cg');
subplot(1,2,2);
semilogy(m,r2);
title('precg');
