function mingmpregm(A)

[p, n] = size(A);
if p ~= n
   error('The matrix must be square');
end

m = 5:100;
k = length(m);
b = ones(n,1);
x0 = randn(n,1);
r1 = zeros(k,1);
r2 = zeros(k,1);
r3 = zeros(k,1);

disp('Minimum residual method.');
tic;
for i = 1:k
[~, r1(i), ~] = minresb(A,b,x0,m(i),1.0e-6,100);
end
toc;

disp('General minimum residual method');
tic;
for i = 1:k
[~, r2(i), ~] = gmresb(A,b,x0,m(i),1.0e-6,100);
end
toc;

disp('Preconditioned general minimum residual method');
tic;
for i = 1:k
   [~, r3(i), ~] = mpregmres(A,b,x0,m(i),1.0e-6,100);
end
toc;

subplot(1,3,1);
semilogy(m,r1);
title('minres');
subplot(1,3,2);
semilogy(m,r2);
title('gmres');
subplot(1,3,3);
semilogy(m,r3);
title('mpregmres');
