function  A = bidiagdemo(A)
%BIDIAGDEMO  Demonstrates reduction to bidiagonal form.
%B = bidiagdemo(A)  reduces the matrix A to bidiagonal form. 
%using the function hzero to zero-out entries under the
%diagonal and under the lower diagonal in the transpose
%input  : Matrix A
%output : Matrix A

[m,n] = size(A);

n = min(m-1, n);

A(abs(A)<1.e-12)=0;
spy(A);
pause;

for i = 1:n
   A = hzero2(A,i,i);
   if i <= n-1
      A = hzero2(A,i,i+1,1);
   end
   
   A(abs(A)<1.e-12)=0;
   spy(A);
   pause;
end
A = bid(diag(A),diag(A,1));

A(abs(A)<1.e-12)=0;
spy(A);
pause;
	
end
