function D = eigsymbdemo(A)

[m, n] = size(A);
if m ~= n
	error('The matrix is not square.');
end

if issym(A) == false
   error('The matrix is not symmetric.');
end

tol = 1.0e-5;
maxiter = 50;

T = trireducedemo(A);
disp('Reduction to tridiagonal form complete.');
disp('Beginning the chase');
pause;

[~, T] = trireduce(A);
for k=n:-1:2
	iter = 0;
   while abs(T(k,k-1)) > tol*(abs(T(k,k)+ abs(T(k-1,k-1))))
		if iter > maxiter
			fprintf('Failure of convergence. ');
			fprintf('Current eigenvalue approximation %g\n',T(k,k));
			break;
      end
      T(1:k,1:k) = chasedemo(T(1:k,1:k));
      iter = iter + 1;
   end
   T(k,k-1) = 0;
	T(k-1,k) = 0;
end

D = diag(T);
spy(T);
pause;
