function [E, numsweeps] = eigsymjdemo(A)
%CYCSYMEIG Executes the cyclic-by-row Jacobi method that approximates
%the eigenvalues of a real symmetric matrix.
%[E numsweeps] = cycsymeig(A,tol,maxsweeps) executes the Jacobi iteration
%until the error tolerance is reached or maxsweeps sweeps
%have been performed. The error is measured by computing off(A),the
%square root of the sum of the squares of the off-diagonal
%elements of A after every sweep. off(A) -> 0 as the number
%of sweeps increases. If the desired tolerance is not obtained
%within maxsweeps sweeps, a value of -1 is returned for numsweeps.
%Input: symmetric matrix A
%Output: A column vector whose elements are
%approximations to the eigenvalues of A and the number
%of sweeps required.


if issym(A) == false
	disp('The matrix is not symmetric.');
	return;
end

[n m] = size(A);
maxsweeps = 10;
tol = 1.0e-6;

desired_accuracy = false;
numsweeps = 0;
spy(A);
pause;

while numsweeps <= maxsweeps && ~desired_accuracy
	numsweeps = numsweeps + 1;
	% execute a cycle of n(n-1)/2 iterations
	for i=1:n-1
		for j = i+1:n
			%compute c and s so that A(i,j) = A(j,i) ~= 0.
			[c, s] = jacobics(A,i,j);
			%Compute A = J(i,j,c,s)'*A*J(i,j,c,s)
			A = jacobimul(A,i,j,c,s);
% 			A(find(abs(A)<1.e-7))=0;
			A(abs(A)<1.e-7)=0;
			spy(A);
			pause;
		end
	end 
	if off(A) < tol
		desired_accuracy = true;
	end
end
spy(A);
pause;

if desired_accuracy == false
	numsweeps = -1;
end

E = diag(A);
