function [c, lambda] = eigcond(A)
%eigcond Compute the condition number of the distict eigenvalues of
%the n x n matrix A.
%   [c lambda] = eigcond(A) returns a vector c such that c(i)
%   is the condition number of eigenvalue lambda(i).

[m, n] = size(A);
if m ~= n
   error('The matrix is not square.');
end

[X, D] = eig(A);
lambda = diag(D);
c = zeros(n,1);
invXt = inv(X)';
for i = 1:n
   x = X(:,i)/norm(X(:,i));
   y = invXt(:,i)/norm(invXt(:,i));
   c(i) = 1/abs(y'*x);
end
