function E = eigqrbasic(A,maxiter)
%eigqrbasic QR iteration for computing all
%the eigenvalues of a real n x n matrix having
%distinct eigenvalues.
%
%   E = eigqrbasic(A, numiter) executes the QR iteration
%   for matrix A numiter times and returns a column
%   vector E containing the approximate eigenvalues
%   in decreasing order of magnitude.

[m,n] = size(A);
if m ~= n
	disp('The matrix is not square.');
	return;
end

if nargin == 1
   tol = 1.0e-10;
   maxiter = 1000;
end

for k= 1:maxiter
	[Q, R] = hqr(A);
	A = R*Q;
end

E = diag(A);
