function [Q, R] = givenshessqr(H)
%givenshessqr: QR factorization of an n x n upper Hessenberg
%matrix using Givens rotations.
%
%   [Q R] = givenshessqr(H) For n x n upper Hessenberg matrix A,
%   returns an n x n upper triangular matrix R and an n x n
%   orthogonal upper Hessenberg matrix Q such that H = QR.

n = size(H,1);
Q = eye(n,n);

for i= 1:n-1
   [c,s] = givensparms(H(i,i),H(i+1,i));
   H = givensmul(H,i,i+1,c,s);
   Q = givensmul(Q,i,i+1,c,s);
end

R = H;
Q = Q';
