function [Q,R] = givensqr(A)
%givensqr full QR factorization by Givens rotations. 
%
%   [Q,R] = givensqr(A) returns an m x m orthogonal matrix Q
%   and an m x n upper triangular matrix R such that A = QR

[m,n] = size(A);

Q = eye(m,m);

for i= 1:min(m-1,n)
	for j = i+1:m
		[c,s] = givensparms(A(i,i),A(j,i));
		A = givensmul(A,i,j,c,s);
		Q = givensmul(Q,i,j,c,s);
	end
end

R = A;
Q = Q';
