function A = hmulp(A,u) 
% HMULP Computes A*Hu, where Hu is a Householder matrix
% defined by u.
% A = hmulp(A,u) 
% input  : Matrix A and vector u
% output : Matrix A

   % form A*Hu (post multiply by Hu)
   if norm(u) ~= 0
      A = A - (2/norm(u)^2)*A*(u*u');
   end
