function [u, beta, sign] = houseparms(x)
%HOUSEPARMS computes the vector u and the scalar
%beta required to form a Householder reflection.
%
%   [u beta sign] = houseparms(x) returns the Householder vector u,
%   the constant beta, and the negative of the sign used to create x(1).

colmax = max(abs(x));
% scale the elements as long as the maximum absolute value
% is not 0
if colmax ~= 0
	x = x/colmax;
	colnorm = norm(x);
else
	colnorm = 0;
end

if x(1) >= 0
	x(1) = x(1) + colnorm;
	sign = -1;
else
	x(1) = x(1) - colnorm;
	sign = 1;
end

if norm(x) ~= 0
	beta = 2/norm(x)^2;
else
	beta = 0;
end
u = x;