function H = hsym(A,i)
%hsym builds the n x n Householder matrix with the embedded
%(n-i) x (n-i) Householder submatrix used to zero out elements
%(i+2,i),..., (n,i).
%
%   This function is for demonstration purposes only. Normally,
%   Householder matrix operations are done implicitely.

n = size(A,1);
H = eye(n);
[u, beta] = house(A,i+1,i);
k = i+1;
H(k:n,k:n) = eye(n-i)-beta*(u*u');
