function [A, u] = hzero(A,i)
%hzero Zero out all elements A(i+1,i), ..., A(m,i) of
%an m x n matrix A using a Householder reflection.
%
%   [A u] = hzero(A,i) returns a new matrix A implicitely
%   premultiplied by an m x m Householder matrix Hu.
%   Also returns the vector u used to construct the
%   Householder reflection Hu.

[m, n] = size(A);

[A(i:m,i:n), u] = hzero1(A(i:m,i:n));
