function [A, u] = hzero1(A)
%HZERO1 Zero out all elements A(2,1), ..., A(m,1) in
%the m x n matrix A using a Householder reflection.
%
%   [A u] = hzero1(A) returns u and a new matrix A implicitely
%   premultiplied by the Householder matrix Hu.

% find u for the Householder reflection
x = A(:,1);
% find the maximum element in absolute value in column 1.
colmax = max(abs(x));
if colmax == 0
   u = zeros(length(x),1);
   return;
end
x = x/colmax;
colnorm = norm(x);
u = x;

if u(1) >= 0
   u(1) = u(1)+ colnorm;
else
   u(1) = u(1) - colnorm;
end

% implicitely form Hu*A
unorm = norm(u);
if unorm ~= 0
   beta = 2/unorm^2;
else
   beta = 0;
end
A = A - u*((beta*u')*A);
