function result = isposdef(A)
%isposdef Determine if a matrix is positive definite.
%
%   result = isposdef(A) returns 1 if A is symmetric and
%   positive definite and 0 if not. Only use this function
%   with small matrices; otherwise, use MATLAB's chol or the
%   book's cholesky.

result = all(all(A == A')) & min(eig( A )) > 0;