function s = issym(A)
%issym Determine if a matrix is symmetric
%
%   s = issym(A) returns 1 if A is symmetric and 0 if not.

n = size(A,1);
for i = 1:n
	for j = i+1:n
		if abs(A(i,j) - A(j,i)) > 1.0e-12
			s = false;
			return
		end
	end
end
s = true;