function [c, s] = jacobics(A,i,j)
%jacobics Compute the values c, s for the Jacobi rotation
%used in the computation of the eigenvalues of a real
%symmetric matrix using the Jacobi method.
%
%   [c s] = jacobi(A,i,j) determines Jacobi rotation parameters
%   c and s such that J(i,j,c,s)'*A*J(i,j,c,s) zeros-out
%   A(i,j) and A(j,i), i ~= j.
   
%determine if A(i,j) is 0 and compute accordingly
if A(i,j) ~= 0
	tau = (A(j,j) - A(i,i))/(2*A(i,j));
	if tau >= 0
		t = 1/(tau + sqrt(tau^2 + 1));
	else
		t = -1/(-tau + sqrt(tau^2 + 1));
	end
	c = 1/sqrt(1 + t^2);
	s = c*t;
else
	c = 1.0;
	s = 0.0;
end
