function [m, b] = linlstsq( x,y )
%Compute the linear least squares
% line for the data x,y

Sx = 0;
Sy = 0;
Sxy = 0;
Sxx = 0;
n = length(x);
for i = 1:n
    Sx = Sx + x(i);
    Sy = Sy + y(i);
    Sxy = Sxy + x(i)*y(i);
    Sxx = Sxx + x(i)^2;
end

m = (n*Sxy -Sx*Sy)/(n*Sxx -Sx^2);
b = (Sxx*Sy - Sxy*Sx)/(n*Sxx -Sx^2);

end

