function x = lqiterimp(A,b,x0,maxiter)
%lqiterimp1 Iterative refinement of a least-squares solution.
%
%   x = iterref(A,b,x0,numiter) iteratively computes succesive
%   refinements of an initial least-squares solution x0 of the
%   system Ax = b. maxiter is the user supplied number of iterations.
%   x is the (hopefully) improved solution.

xk = x0;
for k = 1:maxiter	
	%compute the residual vector
	r = b - A*xk;
	c = qrlstsq(A, r);
	x_kp1 = xk + c;
	xk = x_kp1;
end
x = xk;

