function [L, U] = lugauss(A) 
%lugauss LU factorization using Gaussian elimination without pivoting.
%
%   [L U] = lugauss(A) factors A so that A = L*U. It is assumed that
%   a zero never occurs on the diagonal during the process or row
%   elimination. It a zero occurs, the function writes an error
%   message and terminates. NOTE: This function is primarily intended
%   for instructional purposes. Normally, pivoting is used.

[~,n] = size(A);
for i = 1:n-1 
	if (A(i,i) == 0)
		disp('the algorithm has encountered a zero pivot');
		% make L and U empty matrices
		L=[];
		U=[];
		return;
	end;
	
	%replace the elements in column i, rows i+1 to n by
	%the multipliers that we will store in L
	A(i+1:n,i) =  A(i+1:n,i)/ A(i,i);
	%modify the elements in rows i+1 to n, columns i+1 to n by subtracting
   %the multiplier for the row times the elements in row i
	A(i+1:n,i+1:n)  = A(i+1:n,i+1:n)  - A(i+1:n,i) * A(i,i+1:n);
end;

%U is the upper triangular portion of A
U = triu(A);
%assign L all elements below the main diagonal of A
L =  tril(A,-1);
%put ones on the diagonal of L
for i = 1:n
	L(i,i) = 1;
end;

