function y = off(A)
%off Compute the square root of the sum of the off-diagonal entries of
%a symmetric matrix.
%
%   y = off(A) returns sqrt(sum(a_ij^2, i ~= j)) for symmetric matrix A.

n = size(A,1);
sum = 0.0;

for i = 1:n
	for j = i+1:n
		sum = sum + A(i,j)^2;
	end
end

y = sqrt(2*sum);