function [r, lambda] = perronfro(R)
%perronfro: Find the largest eigenvector of a ranking matrix.
%
%   [r lambda] = perronfro(R) computes the largest eigenvector, lambda,
%   and its corresponding eigenvector r using the power method.
%   R is a ranking matrix.

n = size(R,1);
r0 = ones(n,1);
xprev = r0/norm(r0);
tol = 1.0e-14;

for i = 1:500
	% generate the next approximation
	xnew = R*xprev;
	xnew = xnew/norm(xnew);
	lambda = xnew'*(R*xnew);
	% compute the error
	if norm(R*xnew-lambda*xnew) < tol
		r = xnew;
		lambda = ((R*r)'*r)/(r'*r);
		return;
	end
	xprev = xnew;
end
