function R = rankmatrix(S)
%rankmatrix Form a ranking matrix from a matrix of scores.
%
%   R = rankmatrix(S) returns a ranking matrix obtained by applying
%   the formula R(i,j) = (S(i,j) + 1)/(S(i,j) + S(j,i) + 2).

[m, n] = size(S);
if m ~= n
   error('The matrix of scores must be square.');
end

R = zeros(n,n);
for i = 1:n
   for j = 1:n
      R(i,j) = (S(i,j) + 1)/(S(i,j) + S(j,i) + 2);
   end
end
