function A = strakos(n,lambda_1,lambda_n,rho)
%STRAKOS Generate a Strakos diagonal matrix.
%
%   A = strakos(n,lambda_1,lambda_n,rho)
%
%     Generates a diagonal matrix whose diagonal entries
%     are its eigenvalues distributed between lambda_1 and
%     lambda_n. The parameter rho controls the distribution.

A = zeros(n,n);
A(1,1) = lambda_1;
A(n,n) = lambda_n;
for i = 1:n
   A(i,i) = lambda_1 + ((i-1)/(n-1))*(lambda_n-lambda_1)*rho^(n-i);
end
