function svdgeom(A)

% build the unit circle
t=0:0.01:2*pi; 
x=cos(t)';y=sin(t)';
npts = length(t);
Ax = zeros(npts,1);
%Image of the unit circle under A
for i = 1:npts
	v=[x(i);y(i)];
	w=A*v; 
	Ax(i)=w(1);
	Ay(i)=w(2); 
end 
% Plot of the circle and its image
plot(x,y,Ax,Ay,'.','MarkerSize',10,'LineWidth',3);
grid on; axis equal;
title('Action of a linear transformation on the unit circle');
xlabel('x'); ylabel('y');
disp('The singular value decomposition for A is');
[U, S, V] = svd(A)