function A = trid(a,b,c)
%trid constructs an n x n tridiagonal matrix.'
%
%   A = trid(a,b,c) constructs a tridiagonal matrix A with lower diagonal
%   a [(n-1) x 1], primary diagonal b [(n x 1)], and upper diagonal
%   c [(n-1) x 1].

A = diag(a,-1) + diag(b) + diag(c,1);
