function [L,U] = tridiagLU(a,b,c)
%tridiaglu Compute the LU factorization of a tridiagonal matrix into
%two bidiagonal matrices.
%
%   [L,U] = tridiagLU(a,b,c) factors the tridiagonal matrix
%   T = trid(a,b,c). L is the subdiagonal of the left bidiagonal factor,
%   and U is the diagonal of the right bidiagonal factor. Use tridiagLU
%   as preparation solving the system Tx = rhs using
%   x = trisolve(L,U,c,rhs).

n = length(b);
L = zeros(n-1,1);
U = L;
U(1) = b(1);
for i=1:n-1
    L(i) = a(i)/U(i);
    U(i+1) = b(i+1) - L(i)*c(i);
end
