function [L, U] = trifact(T)
%trifact LU factorization of a tridigonal matrix
%
%   [L U] = trifact(T) factors T into a unit lower bidiagonal matrix L
%   and an upper triangular matrix U.

% NOTE: We can save a great deal of space by representing
% A using three one-dimensional arrays containing the diagonals
% of T and representing each of L and U using two one dimensional
% arrays. For simplicity, we will not use this strategy
% for trifact, but will do so with the function tridagLU
% presented in Chapter 13.

[n, m] = size(T);
if n ~= m
	disp('The matrix is not square.');
	return;
end

L = zeros(n,n);
U = zeros(n,n);

U(1,1) = T(1,1);
if U(1,1) == 0
	disp('The factorization failed.');
	return;
end
U(1,2) = T(1,2);
L(1,1) = 1;

for i = 2:n
	L(i,i) = 1;
	tmp = T(i,i-1)/U(i-1,i-1);
	L(i,i-1) = tmp;
	U(i,i) = T(i,i) - tmp*T(i-1,i);
	if U(i,i) == 0
		disp('The factorization failed');
		return;
	end
	if i ~= n
		U(i,i+1) = T(i,i+1);
	end
end

